import numpy as np
import matplotlib.pyplot as plt
width = 0.5

colum1 = [0.9936922835706201, 0.9919168969686029, 0.9984709803762714, 0.9987550333242384, 0.9999999999999989,
     0.9989983309244042, 0.996590052435739, 0.9991300501925077, 0.9995742365865818, 0.9987206753904606,
     0.9987497542061256, 0.9986710781006138, 0.997892004898773, 0.9993707268773535, 0.9993563530942873]
colum2 = [0.5032950612461846, 0.49693276212003185, 0.4825555342729782, 0.49772954661074637, 0.4971927926680654,
     0.5003134212456856, 0.5002563600249409, 0.4981442337691825, 0.4903187263127347, 0.506137890789829,
     0.5000104867011795, 0.5017245412120656, 0.4957532328122014, 0.5036893325914513, 0.5031821912982302]
colum3 = [0.33356649374852815, 0.3330911828669024, 0.33638257827809087, 0.3331691747368029, 0.3326449547851533,
     0.334023764032588, 0.3363238024027001, 0.33056855032034543, 0.33230904303095604, 0.334377950011936,
     0.33496202243845935, 0.3341371348775828, 0.334218142863619, 0.3311393702461457, 0.3353764301965302]
colum4 = [0.24671272109460296, 0.24811900862974495, 0.25191693794231684, 0.24839142053980387, 0.248370066634504,
     0.2503042985153399, 0.2507066789613477, 0.24910948735277336, 0.247346403584365, 0.2475546307830005,
     0.24627186364001963, 0.2493739958141489, 0.25131388884763906, 0.2498457082053936, 0.24836397624313158]


colum = [colum1,colum2,colum3,colum4]
btm = [0.9591751709536137, 0.47958758547680685, 0.3197250569845379, 0.23979379273840343]

labels = ['1', '2', '3', '4']
x = np.arange(len(labels))

fig, ax = plt.subplots()
size = 12
ax.tick_params(axis='both', which='major', labelsize=size)
ax.tick_params(axis='both', which='minor', labelsize=size)
plt.rc('font', size=size)
plt.rc('axes', titlesize=size)
plt.rc('axes', labelsize=size)
plt.rc('xtick', labelsize=10)
plt.rc('ytick', labelsize=size)
plt.rc('legend', fontsize=14)
plt.rc('figure', titlesize=size)
ax.bar(x, btm, width, label="Theoretical", edgecolor='k', color = '#929591')

for i in range(15):
    scy = []
    for j in x:
        scy.append(colum[j][i])
    if i == 0:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1, label="Experimental")
    else:
        ax.scatter(x, scy, color='#E50000', edgecolor='k', marker='o', zorder=1)
ax.bar(x, 1, width, edgecolor='k', zorder=0, color = '#FAC205')
ax.set_ylabel(r"$\mathbb{E}\left[ALG\right]$ / $\max$ OPT", fontsize=18)
ax.set_xlabel(r"$L$", fontsize=18)
ax.set_xticks(x)
ax.set_xticklabels(labels)
ax.legend(ncol=3, loc='lower center', bbox_to_anchor=(0.5, 1))
ax.set_ylim(0.2, 1.005)
plt.rcParams["font.family"] = "Times New Roman"
plt.rc('pdf',fonttype = 42)
plt.rc('ps',fonttype = 42)
plt.style.use('classic')
plt.tight_layout()
figure = plt.gcf()
figure.savefig("Set1-3.pdf")
plt.show()